{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 *}

<div class="row" id="wing_config">
  	<div class="col-md-offset-1 col-md-11" id="wing_config_main">
  		<form action="{$post_uri|escape:'htmlall':'UTF-8'}" class="form-horizontal" method="post">
		  	<div class="row margin-bottom-10">
			  	<div class="col-md-3 text-left">
					<span style="font-size: 18px">
						{l s='Configure your shop' mod='wing' d='Modules.Mymodule.Somefile'} {$psName|escape:'htmlall':'UTF-8'}
					</span>
				</div>
			</div>

			<div class="panel">
				<div class="panel-heading">
					<i class="icon-user"></i> {l s='Authentification settings' mod='wing'}
				</div>
				<div class="form-group">
					<div class="col-md-8">
						<label>{l s='API Key' mod='wing'}</label>
						<input id="apiKey" type="text" name="apiKey" value="{$apiKey|escape:'htmlall':'UTF-8'}"/>
					</div>
				</div>

				<div class="form-group">
					<div class="col-md-8">
						<label>{l s='API Secret' mod='wing'}</label>
						<input id="apiSecret" type="text" name="apiSecret" value="{$apiSecret|escape:'htmlall':'UTF-8'}" />
					</div>
				</div>
			</div>

			<div class="panel">
				<div class="panel-heading">
					<i class="icon-refresh"></i> {l s='Synchronization settings' mod='wing'}
				</div>

				<div class="form-group">
					<label class="col-md-12" required>{l s='Select synchronization statuses' mod='wing'}</label>
					<div class="col-md-4">
						{foreach from=$orderStatuses item=orderStatus}
							{assign var=orderStateIdClass value='ORDER_STATE_{$orderStatus.id_order_state}'}
							{assign var=badgeClass value='badge'}
							<div class="checkbox">
								<label for="{$orderStateIdClass|classname}">
									<input type="checkbox" name="syncStatuses[]" value={$orderStatus.id_order_state} id="{$orderStateIdClass|classname}" {if in_array($orderStatus.id_order_state, $syncStatuses)}checked{/if}>
									<span class="{$badgeClass|classname}" style="background-color:{$orderStatus.color}">{$orderStatus.name}</span>
								</label>
							</div>
						{/foreach}
					</div>
				</div>

				<div class="form-group margin-top-25">
					<div class="col-md-4">
						<label for="orderStatusesSelect" required>{l s='Select status to set once the order has been prepared' mod='wing'}</label>
						<select id="orderStatusesSelect" name="preparedStatus" class="form-control">
							{foreach from=$orderStatuses item=orderStatus}
								<option value="{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if $orderStatus.id_order_state == $preparedStatus}selected{/if}>{$orderStatus.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
				</div>
				<div class="form-group margin-top-25">
					<div class="col-md-4">
						<label for="orderStatusesSelect" required>{l s='Select status to set once the order has been shipped' mod='wing'}</label>
						<select id="orderStatusesSelect" name="shippedStatus" class="form-control">
							{foreach from=$orderStatuses item=orderStatus}
								<option value="{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if $orderStatus.id_order_state == $shippedStatus}selected{/if}>{$orderStatus.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
				</div>
				<div class="form-group margin-top-25">
					<div class="col-md-4">
						<label for="orderStatusesSelect" required>{l s='Select status to set once the order has been delivered' mod='wing'}</label>
						<select id="orderStatusesSelect" name="deliveredStatus" class="form-control">
							{foreach from=$orderStatuses item=orderStatus}
								<option value="{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if $orderStatus.id_order_state == $deliveredStatus}selected{/if}>{$orderStatus.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
				</div>
			</div>

			<div class="panel" class="advancedSettings">
				<div class="panel-heading">
					<i class="icon-cog"></i> {l s='Advanced settings' mod='wing'} - Wing {$wingModuleVersion|escape:'htmlall':'UTF-8'}
				</div>
				<div class="row">
					<div class="form-group">
						<div class="col-md-8">
							<div class="row margin-bottom-10">
								<div class="col-md-4">
									<div class="checkbox">
										<label>
											<input id="autoAddToCollect" type="checkbox" name="autoAddToCollect" value={$autoAddToCollect|escape:'htmlall':'UTF-8'} {if $autoAddToCollect == 1}checked{/if}/>
											<span class="badge">{l s='Auto add to collect' mod='wing'}</span>
										</label>
									</div>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
 									<label>{l s='Pickup Name' mod='wing'}</label>
									<input id="pickupName" type="text" name="pickupName" value="{$pickupName|escape:'htmlall':'UTF-8'}" />
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-6">
 									<label for="advancedSettingsSelect" required>{l s='Wing API Url' mod='wing'}</label>
 									<input id="apiBaseUrl" type="text" name="apiBaseUrl" value="{$apiBaseUrl|escape:'htmlall':'UTF-8'}"/>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
								    <label for="advancedSettingsSelectDesignation" required>{l s='Select the item\'s designation Mapping field' mod='wing'}</label>
									<select id="advancedSettingsSelectDesignation" name="designationField" class="form-control">
										{foreach from=$itemFields item=itemField}
											<option value="{$itemField|escape:'htmlall':'UTF-8'}" {if $designation == $itemField}selected{/if}>{$itemField|escape:'htmlall':'UTF-8'}</option>
										{/foreach}
									</select>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
								    <label for="advancedSettingsSelectSKU" required>{l s='Select the SKU Mapping field' mod='wing'}</label>
									<select id="advancedSettingsSelectSKU" name="skuField" class="form-control">
										{foreach from=$itemFields item=itemField}
											<option value="{$itemField|escape:'htmlall':'UTF-8'}" {if $sku == $itemField}selected{/if}>{$itemField|escape:'htmlall':'UTF-8'}</option>
										{/foreach}
									</select>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
								    <label for="advancedSettingsSelectEAN" required>{l s='Select the EAN Mapping field' mod='wing'}</label>
									<select id="advancedSettingsSelectEAN" name="eanField" class="form-control">
										{foreach from=$itemFields item=itemField}
											<option value="{$itemField|escape:'htmlall':'UTF-8'}" {if $ean == $itemField}selected{/if}>{$itemField|escape:'htmlall':'UTF-8'}</option>
										{/foreach}
									</select>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-4 pull-right text-right margin-bottom-25">
					<button type="submit" class="btn btn-lg text-center">{l s='Save' mod='wing'}</button>
				</div>
			</div>
		</form>
	</div>
</div>
