<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'wing.php';

/**
 * @method public void     __construct()
 * @method public boolean  installDb()
 * @method public boolean  uninstallDb()
 * @method public boolean  removeConfigurations()
 */
class WingOperationsConfigurations
{
    /* Class parameters */
    private $apiMode;

    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * @method public installDb
     *
     * @return bool
     */
    public function installDb()
    {
        $sql = [];
        $return = true;
        include dirname(__FILE__) . '/sql_install.php';
        foreach ($sql as $s) {
            $return &= Db::getInstance()->execute($s);
        }

        return $return;
    }

    /**
     * @method public uninstallDb
     *
     * @return bool
     */
    public function uninstallDb()
    {
        $sql = [];
        include dirname(__FILE__) . '/sql_install.php';
        foreach ($sql as $name) {
            Db::getInstance()->execute('DROP TABLE IF EXISTS ' . $name);
        }

        return true;
    }

    /**
     * @method public removeConfigurations
     *
     * @return bool
     */
    public function removeConfigurations($shopIds)
    {
        foreach ($shopIds as $shopId) {
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_API_BASEURL'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_API_CHANNEL_ID'
            );
            Configuration::deleteByName('WING_SHOP_' . $shopId . '_API_KEY');
            Configuration::deleteByName('WING_SHOP_' . $shopId . '_API_SECRET');
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_BASIC_AUTH_TOKEN'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_SYNC_STATUSES'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_SHIPPED_STATUS'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_MARKUP_DELAY'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_CARRIER_CONF'
            );
        }

        return true;
    }
}
