<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method public void        __construct()
 * @method public array       getCarriers(int $shopId, int $page, int $size)
 */
class WingOperationsCarriers
{
    protected $context;

    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @return void
     */
    public function __construct()
    {
        $this->setContext();
    }

    /**
     * @method public uninstall
     *
     * @return Context
     */
    private function setContext()
    {
        $this->context = Context::getContext();
    }

    /**
     * @method public getCarriers
     *
     * @return array
     */
    public function getCarriers($shopId, $page, $size)
    {
        $db = Db::getInstance();

        $getCarriersRequest = new DbQuery();
        $carriers = $db->executeS(
            $getCarriersRequest
                ->select('*')
                ->from('carrier_lang', 'cl')
                ->leftJoin('carrier', 'c', 'c.id_carrier = cl.id_carrier')
                ->where('id_shop = ' . (int) $shopId . ' AND deleted != 1')
                ->limit((int) $size, (int) ($page - 1) * (int) $size)
        );

        return [
            'shopId' => $shopId,
            'page' => $page,
            'size' => $size,
            'data' => $carriers,
        ];
    }
}
