<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'classes' .
    DIRECTORY_SEPARATOR .
    'helpers.php';

/**
 * @method public void run()
 */
class WingGetOrderIdsModuleFrontController extends ModuleFrontController
{
    /**
     * @method public run
     */
    public function run()
    {
        $context = Context::getContext();
        $shopId = (int) $context->shop->id;

        $apiKey = Configuration::get('WING_SHOP_' . $shopId . '_API_KEY');
        $apiSecret = Configuration::get('WING_SHOP_' . $shopId . '_API_SECRET');
        $psSecurityToken = sha1($apiKey . ':' . $apiSecret);

        /* In case of previous Apache version or nginx server use */
        $requestHeadersToLower = !function_exists('getallheaders')
            ? WingHelpers::getallheaders()
            : getallheaders();

        $requestHeaders = array_change_key_case(
            $requestHeadersToLower,
            CASE_LOWER
        );

        if (false == array_key_exists('x-wing-token', $requestHeaders)) {
            header('HTTP/1.1 401 Unauthorized');
            echo 'Missing x-wing-token header';
            exit;
        } elseif ($requestHeaders['x-wing-token'] != $psSecurityToken) {
            header('HTTP/1.1 401 Unauthorized');
            echo 'Wrong credentials';
            exit;
        } else {
            /* Check url parameters */
            $syncStatusesParams = pSQL(Tools::getValue('syncStatuses'));
            $syncStatuses = !empty($syncStatusesParams)
                ? $syncStatusesParams
                : null;

            if (!$syncStatuses) {
                header('HTTP/1.1 400 Bad request');
                echo 'Mandatory syncStatuses url parameter is missing';
                exit;
            }

            $updatedAfterParam = Tools::getValue('updatedAfter');
            $updatedAfter = !empty($updatedAfterParam)
                ? $updatedAfterParam
                : null;

            if (!$updatedAfter) {
                header('HTTP/1.1 400 Bad request');
                echo 'Mandatory updatedAfter url parameter is missing';
                exit;
            }

            $page = (int) Tools::getValue('page');
            $size = (int) Tools::getValue('size');

            $page = $page > 1 ? $page : 1;
            $size = $size > 0 && $size < 101 ? $size : 10;

            /* Retrieve requested order ids */
            $results = $this->module->orders->getOrderIds(
                $syncStatuses,
                $updatedAfter,
                $shopId,
                $page,
                $size
            );

            header('Content-Type:application/json;charset=utf-8');
            echo json_encode($results);
            exit;
        }
    }
}
