<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'classes' .
    DIRECTORY_SEPARATOR .
    'helpers.php';

/**
 * @method public void run()
 */
class WingGetOrderModuleFrontController extends ModuleFrontController
{
    /**
     * @method public run
     */
    public function run()
    {
        $context = Context::getContext();
        $shopId = (int) $context->shop->id;

        $apiKey = Configuration::get('WING_SHOP_' . $shopId . '_API_KEY');
        $apiSecret = Configuration::get('WING_SHOP_' . $shopId . '_API_SECRET');
        $psSecurityToken = sha1($apiKey . ':' . $apiSecret);

        /* In case of previous Apache version or nginx server use */
        $requestHeadersToLower = !function_exists('getallheaders')
            ? WingHelpers::getallheaders()
            : getallheaders();

        $requestHeaders = array_change_key_case(
            $requestHeadersToLower,
            CASE_LOWER
        );

        $paramOrderId = Tools::getValue('orderId');
        $orderId = !empty($paramOrderId) ? $paramOrderId : null;

        if (false == array_key_exists('x-wing-token', $requestHeaders)) {
            header('HTTP/1.1 401 Unauthorized');
            echo 'Missing x-wing-token header';
            exit;
        } elseif ($requestHeaders['x-wing-token'] != $psSecurityToken) {
            header(Tools::strtolower('HTTP/1.1 401 Unauthorized'));
            echo 'Wrong credentials';
            exit;
        } elseif (!$orderId) {
            header(Tools::strtolower('HTTP/1.1 401 Unauthorized'));
            echo 'Missing orderId query parameter';
            exit;
        } else {
            /* Retrieve the requested order */
            $orderData = $this->module->orders->getOrder($orderId);
            $order = $this->module->orders->mapOrder($orderData, $shopId);

            header('Content-Type:application/json;charset=utf-8');
            echo json_encode($order);
            exit;
        }
    }
}
