<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method public void              __construct()
 * @method public static void       autoload(array $files)
 * @method public static string     setEndpoint(string $endpoint, string $id)
 * @method public static void       log(string $msg, int $level = 1)
 * @method public static string     base64UrlEncode(string $data)
 */
class WingHelpers
{
    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * @method public static autoload
     *
     * @param array $files
     *
     * @return void
     */
    public static function autoload($files)
    {
        foreach ($files as $file) {
            require_once $file;
        }
    }

    /**
     * @method public static setEndpoint
     *
     * @param string $endpoint
     * @param string $id
     *
     * @return string
     */
    public static function setEndpoint($endpoint, $id)
    {
        if ($id) {
            return $endpoint . '/' . $id;
        }

        return $endpoint;
    }

    /**
     * @method public static log
     *
     * @param string $msg
     * @param int $level = 1
     *
     * @return void
     */
    public static function log($msg, $level = 1)
    {
        if (version_compare(_PS_VERSION_, '1.6.0.0', '>')) {
            PrestaShopLogger::addLog(
                'WING_MODULE : ' . strip_tags(print_r($msg, true)),
                $level,
                null,
                'wing'
            );
        } else {
            Logger::addLog(
                'WING_MODULE : ' . strip_tags(print_r($msg, true)),
                $level,
                null,
                'wing'
            );
        }
    }

    /**
     * @method public static base64UrlEncode
     *
     * @param string $data
     *
     * @return string
     */
    public static function base64UrlEncode($data)
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }

    /**
     * @method public static uniqueMultidimArray
     *
     * @param array $array
     * @param string $key
     *
     * @return string
     */
    public static function uniqueMultidimArray($array)
    {
        $temp_array = [];
        $i = 0;
        $key_array = [];

        foreach ($array as $val) {
            if (!in_array($val['id_reference'], $key_array)) {
                $key_array[$i] = $val['id_reference'];
                $temp_array[$i] = $val;
            }
            ++$i;
        }

        usort($temp_array, function ($a, $b) {
            return $a['id_reference'] - $b['id_reference'];
        });

        return $temp_array;
    }

    /**
     * @method public static getallheaders
     *
     * @return array
     */
    public static function getallheaders()
    {
        $headers = [];
        foreach ($_SERVER as $name => $value) {
            if ('HTTP_' == Tools::substr($name, 0, 5)) {
                $headers[
                    str_replace(
                        ' ',
                        '-',
                        ucwords(
                            Tools::strtolower(
                                str_replace('_', ' ', Tools::substr($name, 5))
                            )
                        )
                    )
                ] = $value;
            }
        }

        return $headers;
    }
}
