<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'classes' .
    DIRECTORY_SEPARATOR .
    'helpers.php';

require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'classes' .
    DIRECTORY_SEPARATOR .
    'apis' .
    DIRECTORY_SEPARATOR .
    'apiRequest.php';

/**
 * @method public void     __construct(string $authToken)
 * @method public array    createChannel(array $payload)
 */
class WingApiChannel extends WingApiRequest
{
    /* Class parameters */

    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @param string $authToken
     *
     * @return void
     */
    public function __construct($authToken, $baseUrl)
    {
        $this->setBaseURL($baseUrl);
        $this->setAuthToken($authToken);
    }

    /**
     * @method public createChannel
     *
     * @param array $payload
     *
     * @return array
     */
    public function createChannel($channel)
    {
        $completePayload = [
            'query' => 'mutation createChannel($input: CreateChannelInput!) { createChannel(input: $input) { id } }',
            'variables' => ['input' => $channel],
        ];

        $response = $this->setHTTPMethod(WingApiRequest::POST)
            ->setPayloadFormat(WingApiRequest::PAYLOAD_FORMAT)
            ->setPayload($completePayload)
            ->executeRequest();

        return $response;
    }

    /**
     * @method public updateChannel
     *
     * @param array $payload
     *
     * @return array
     */
    public function updateChannel($channelId, $updateChannel)
    {
        $channel = [
            'id' => $channelId,
            'name' => $updateChannel['name'],
            'weightUnit' => $updateChannel['weightUnit'],
            'prestashop' => $updateChannel['prestashop']
        ];
        $completePayload = [
            'query' => 'mutation updateChannel($input: UpdateChannelInput!) { updateChannel(input: $input) { id } }',
            'variables' => ['input' => $channel],
        ];
        $response = $this->setHTTPMethod(WingApiRequest::POST)
            ->setPayloadFormat(WingApiRequest::PAYLOAD_FORMAT)
            ->setPayload($completePayload)
            ->executeRequest();

        return $response;
    }
}
