{*
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 *}

<div class="row" id="wing_config">
  	<div class="col-md-offset-1 col-md-11" id="wing_config_main">
  		<form action="{$post_uri|escape:'htmlall':'UTF-8'}" class="form-horizontal" method="post">
		  	<div class="row margin-bottom-10">
			  	<div class="col-md-3 text-left">
					<span style="font-size: 18px">
						{l s='Configure your shop' mod='wing'} {$psName|escape:'htmlall':'UTF-8'}
					</span>
				</div>
			</div>

			<div class="panel">
				<div class="panel-heading">
					<i class="icon-user"></i> {l s='Authentification settings' mod='wing'}
				</div>
				<div class="form-group">
					<div class="col-md-8">
						<label>{l s='API Key' mod='wing'}</label>
						<input id="apiKey" type="text" name="apiKey" value="{$apiKey|escape:'htmlall':'UTF-8'}"/>
					</div>
				</div>

				<div class="form-group">
					<div class="col-md-8">
						<label>{l s='API Secret' mod='wing'}</label>
						<input id="apiSecret" type="text" name="apiSecret" value="{$apiSecret|escape:'htmlall':'UTF-8'}" />
					</div>
				</div>

				<div class="form-group">
					<div class="col-md-8">
						<label>{l s='Pickup Name' mod='wing'}</label>
						<input id="pickupName" type="text" name="pickupName" value="{$pickupName|escape:'htmlall':'UTF-8'}" />
					</div>
				</div>
			</div>

			<div class="panel">
				<div class="panel-heading">
					<i class="icon-refresh"></i> {l s='Synchronization settings' mod='wing'}
				</div>

				<div class="form-group">
					<label class="col-md-12" required {if $is15}{assign var='labelHeight' value=count($order_states) * 14} style="height: {$labelHeight}px;"{/if}>{l s='Select synchronization statuses' mod='wing'}</label>
					<div class="col-md-4" {if $is15}style="margin: 10px 0;"{/if}>
						{if $is15}
							<ul class="checkbox">
								{foreach from=$orderStatuses item=orderStatus}
								<li>
									<div for="ORDER_STATE_{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}">
										<input type="checkbox" name="syncStatuses[]" value="{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" id="ORDER_STATE_{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if in_array($orderStatus.id_order_state, $syncStatuses)}checked{/if}>
										<span class="badge" style="background-color:{$orderStatus.color|escape:'htmlall':'UTF-8'}">{$orderStatus.name|escape:'htmlall':'UTF-8'}</span>
									</div>
								</li>
								{/foreach}
							</ul>
						{else}
							{foreach from=$orderStatuses item=orderStatus}
								<div class="checkbox">
									<label for="ORDER_STATE_{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}">
										<input type="checkbox" name="syncStatuses[]" value="{$orderStatus.id_order_state}" id="ORDER_STATE_{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if in_array($orderStatus.id_order_state, $syncStatuses)}checked{/if}>
										<span class="badge" style="background-color:{$orderStatus.color|escape:'htmlall':'UTF-8'}">{$orderStatus.name|escape:'htmlall':'UTF-8'}</span>
									</label>
								</div>
							{/foreach}
						{/if}
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-12" required {if $is15}{assign var='labelHeight' value=count($warehousesList) * 14} style="height: {$labelHeight}px;"{/if}>{l s='Select warehouses' mod='wing'}</label>
					<div class="col-md-4" {if $is15}style="margin: 10px 0;"{/if}>
						{if $is15}
							<ul class="checkbox">
								{foreach from=$warehousesList item=warehouse}
								<li>
									<div for="WAREHOUSE_{$warehouse.id_warehouse|escape:'htmlall':'UTF-8'}">
										<input type="checkbox" name="warehouses[]" value="{$warehouse.id_warehouse|escape:'htmlall':'UTF-8'}" id="WAREHOUSE_{$warehouse.id_warehouse|escape:'htmlall':'UTF-8'}" {if in_array($warehouse.id_warehouse, $warehouses)}checked{/if}>
										<span class="badge">{$warehouse.name|escape:'htmlall':'UTF-8'}</span>
									</div>
								</li>
								{/foreach}
							</ul>
						{else}
							{foreach from=$warehousesList item=warehouse}
								<div class="checkbox">
									<label for="WAREHOUSE_{$warehouse.id_warehouse|escape:'htmlall':'UTF-8'}">
										<input type="checkbox" name="warehouses[]" value="{$warehouse.id_warehouse}" id="WAREHOUSE_{$warehouse.id_warehouse|escape:'htmlall':'UTF-8'}" {if in_array($warehouse.id_warehouse, $warehouses)}checked{/if}>
										<span>{$warehouse.name|escape:'htmlall':'UTF-8'}</span>
									</label>
								</div>
							{/foreach}
						{/if}
					</div>
				</div>

				<div class="form-group margin-top-25">
					<div class="col-md-4">
						<label for="orderStatusesSelect" required>{l s='Select status to set once the order has been prepared' mod='wing'}</label>
						<select id="orderStatusesSelect" name="preparedStatus" class="form-control">
							{foreach from=$orderStatuses item=orderStatus}
								<option value="{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if $orderStatus.id_order_state == $preparedStatus}selected{/if}>{$orderStatus.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
				</div>
				<div class="form-group margin-top-25">
					<div class="col-md-4">
						<label for="orderStatusesSelect" required>{l s='Select status to set once the order has been shipped' mod='wing'}</label>
						<select id="orderStatusesSelect" name="shippedStatus" class="form-control">
							{foreach from=$orderStatuses item=orderStatus}
								<option value="{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if $orderStatus.id_order_state == $shippedStatus}selected{/if}>{$orderStatus.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
				</div>
				<div class="form-group margin-top-25">
					<div class="col-md-4">
						<label for="orderStatusesSelect" required>{l s='Select status to set once the order has been delivered' mod='wing'}</label>
						<select id="orderStatusesSelect" name="deliveredStatus" class="form-control">
							{foreach from=$orderStatuses item=orderStatus}
								<option value="{$orderStatus.id_order_state|escape:'htmlall':'UTF-8'}" {if $orderStatus.id_order_state == $deliveredStatus}selected{/if}>{$orderStatus.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
				</div>
			</div>

			<div class="panel" class="advancedSettings">
				<div class="panel-heading">
					<i class="icon-cog"></i> {l s='Advanced settings' mod='wing'} - Wing v{$wingModuleVersion|escape:'htmlall':'UTF-8'}
				</div>
				<div class="row">
					<!-- Standard delivery -->
					<div class="form-group">
						<div class="col-md-8">
							<div class="row margin-bottom-10">
								<div class="col-md-6">
 									<label for="advancedSettingsSelect" required>{l s='Wing API Url' mod='wing'}</label>
 									<input id="apiBaseUrl" type="text" name="apiBaseUrl" value="{$apiBaseUrl|escape:'htmlall':'UTF-8'}"/>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
								    <label for="advancedSettingsSelectDesignation" required>{l s='Select the item\'s designation Mapping field' mod='wing'}</label>
									<select id="advancedSettingsSelectDesignation" name="designationField" class="form-control">
										{foreach from=$itemFields item=itemField}
											<option value="{$itemField|escape:'htmlall':'UTF-8'}" {if $designation == $itemField}selected{/if}>{$itemField|escape:'htmlall':'UTF-8'}</option>
										{/foreach}
									</select>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
								    <label for="advancedSettingsSelectSKU" required>{l s='Select the SKU Mapping field' mod='wing'}</label>
									<select id="advancedSettingsSelectSKU" name="skuField" class="form-control">
										{foreach from=$itemFields item=itemField}
											<option value="{$itemField|escape:'htmlall':'UTF-8'}" {if $sku == $itemField}selected{/if}>{$itemField|escape:'htmlall':'UTF-8'}</option>
										{/foreach}
									</select>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
								    <label for="advancedSettingsSelectEAN" required>{l s='Select the EAN Mapping field' mod='wing'}</label>
									<select id="advancedSettingsSelectEAN" name="eanField" class="form-control">
										{foreach from=$itemFields item=itemField}
											<option value="{$itemField|escape:'htmlall':'UTF-8'}" {if $ean == $itemField}selected{/if}>{$itemField|escape:'htmlall':'UTF-8'}</option>
										{/foreach}
									</select>
								</div>
							</div>
							<div class="row margin-bottom-10">
								<div class="col-md-4">
								    <label for="advancedSettingsSelectWeight" required>{l s='Select the Weight unit' mod='wing'}</label>
									<p>{$weight|escape:'htmlall':'UTF-8'}</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-4 pull-right text-right margin-bottom-25">
					<button type="submit" class="btn btn-lg text-center">{l s='Save' mod='wing'}</button>
				</div>
			</div>
		</form>
	</div>
</div>
