<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit();
}

require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'wing.php';

/**
 *
 * @method public   void     __construct()
 *
 * @method public   boolean  installDb()
 * @method public   boolean  uninstallDb()
 *
 * @method public   boolean  removeConfigurations()
 */

class WingOperationsConfigurations
{
    /* Class parameters */
    private $apiMode;

    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * @method public installDb
     *
     * @return boolean
     */
    public function installDb()
    {
        $sql = array();
        $return = true;
        include dirname(__FILE__) . '/sql_install.php';
        foreach ($sql as $s) {
            $return &= Db::getInstance()->execute($s);
        }
        return $return;
    }

    /**
     * @method public uninstallDb
     *
     * @return boolean
     */
    public function uninstallDb()
    {
        $sql = array();
        include dirname(__FILE__) . '/sql_install.php';
        foreach ($sql as $name) {
            Db::getInstance()->execute('DROP TABLE IF EXISTS ' . $name);
        }

        return true;
    }

    /**
     * @method public removeConfigurations
     *
     * @return boolean
     */
    public function removeConfigurations($shopIds)
    {
        foreach ($shopIds as $shopId) {
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_API_BASEURL'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_API_CHANNEL_ID'
            );
            Configuration::deleteByName('WING_SHOP_' . $shopId . '_API_KEY');
            Configuration::deleteByName('WING_SHOP_' . $shopId . '_API_SECRET');
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_BASIC_AUTH_TOKEN'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_SYNC_STATUSES'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_SHIPPED_STATUS'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_MARKUP_DELAY'
            );
            Configuration::deleteByName(
                'WING_SHOP_' . $shopId . '_CARRIER_CONF'
            );
        }

        return true;
    }
}
