<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit();
}

/**
 *
 * @method public void              __construct()
 *
 * @method public static void       autoload(array $files)
 * @method public static string     setEndpoint(string $endpoint, string $id)
 * @method public static void       log(string $msg, int $level = 1)
 * @method public static string     base64UrlEncode(string $data)
 */

class WingHelpers
{
    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * @method public static autoload
     *
     * @param array $files
     *
     * @return void
     */
    public static function autoload($files)
    {
        foreach ($files as $file) {
            require_once $file;
        }
    }

    /**
     * @method public static setEndpoint
     *
     * @param string $endpoint
     * @param string $id
     *
     * @return string
     */
    public static function setEndpoint($endpoint, $id)
    {
        if ($id) {
            return $endpoint . '/' . $id;
        }

        return $endpoint;
    }

    /**
     * @method public static log
     *
     * @param string $msg
     * @param int $level = 1
     *
     * @return void
     */
    public static function log($msg, $level = 1)
    {
        if (version_compare(_PS_VERSION_, '1.6.0.0', '>')) {
            PrestaShopLogger::addLog(
                'WING_MODULE : ' . strip_tags(print_r($msg, true)),
                $level,
                null,
                'wing'
            );
        } else {
            Logger::addLog(
                'WING_MODULE : ' . strip_tags(print_r($msg, true)),
                $level,
                null,
                'wing'
            );
        }
    }

    /**
     * @method public static base64UrlEncode
     *
     * @param string $data
     *
     * @return string
     */
    public static function base64UrlEncode($data)
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }

    /**
     * @method public static uniqueMultidimArray
     *
     * @param array $array
     * @param string $key
     *
     * @return string
     */
    public static function uniqueMultidimArray($array)
    {
        $temp_array = array();
        $i = 0;
        $key_array = array();

        foreach ($array as $val) {
            if (!in_array($val['id_reference'], $key_array)) {
                $key_array[$i] = $val['id_reference'];
                $temp_array[$i] = $val;
            }
            $i++;
        }

        usort($temp_array, function ($a, $b) {
            return $a['id_reference'] - $b['id_reference'];
        });

        return $temp_array;
    }

    /**
     * @method public static getallheaders
     *
     * @return array
     */
    public static function getallheaders()
    {
        $headers = array();
        foreach ($_SERVER as $name => $value) {
            if (Tools::substr($name, 0, 5) == 'HTTP_') {
                $headers[
                    str_replace(
                        ' ',
                        '-',
                        ucwords(
                            Tools::strtolower(
                                str_replace('_', ' ', Tools::substr($name, 5))
                            )
                        )
                    )
                ] = $value;
            }
        }
        return $headers;
    }
}
