<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'classes' .
    DIRECTORY_SEPARATOR .
    'helpers.php';

require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'classes' .
    DIRECTORY_SEPARATOR .
    'apis' .
    DIRECTORY_SEPARATOR .
    'apiRequest.php';

/**
 *
 * @method public void     __construct(string $authToken)
 *
 * @method public array    createChannel(array $payload)
 */

class WingApiChannel extends WingApiRequest
{
    /* Class parameters */

    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @param string $authToken
     *
     * @return void
     */
    public function __construct($authToken, $baseUrl)
    {
        $this->setBaseURL($baseUrl);
        $this->setAuthToken($authToken);
    }

    /**
     * @method public createChannel
     *
     * @param array $payload
     *
     * @return array
     */
    public function createChannel($channel)
    {
        $completePayload = array(
            'query' =>
                'mutation createChannel($input: CreateChannelInput!) { createChannel(input: $input) { id } }',
            'variables' => array('input' => $channel)
        );

        $response = $this->setHTTPMethod(WingApiRequest::POST)
            ->setPayloadFormat(WingApiRequest::PAYLOAD_FORMAT)
            ->setPayload($completePayload)
            ->executeRequest();

        return $response;
    }

    /**
     * @method public updateChannel
     *
     * @param array $payload
     *
     * @return array
     */
    public function updateChannel($channelId, $updateChannel)
    {
        $channel = array(
            'id' => $channelId,
            'name' => $updateChannel['name'],
            'weightUnit' => $updateChannel['weightUnit'],
            'prestashop' => $updateChannel['prestashop']
        );
        $completePayload = array(
            'query' =>
                'mutation updateChannel($input: UpdateChannelInput!) { updateChannel(input: $input) { id } }',
            'variables' => array('input' => $channel)
        );
        $response = $this->setHTTPMethod(WingApiRequest::POST)
            ->setPayloadFormat(WingApiRequest::PAYLOAD_FORMAT)
            ->setPayload($completePayload)
            ->executeRequest();

        return $response;
    }
}
