<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    "wing" .
    DIRECTORY_SEPARATOR .
    "classes" .
    DIRECTORY_SEPARATOR .
    "helpers.php";

/**
 *
 * @method public void run()
 */

class WingUpdateProductModuleFrontController extends ModuleFrontController
{
    /**
     * @method public run
     *
     */
    public function run()
    {
        $context = Context::getContext();
        $shopId = (int) $context->shop->id;

        $apiKey = Configuration::get("WING_SHOP_" . $shopId . "_API_KEY");
        $apiSecret = Configuration::get("WING_SHOP_" . $shopId . "_API_SECRET");
        $psSecurityToken = sha1($apiKey . ":" . $apiSecret);

        /* In case of previous Apache version or nginx server use */
        $requestHeadersToLower = !function_exists("getallheaders")
            ? WingHelpers::getallheaders()
            : getallheaders();

        $requestHeaders = array_change_key_case(
            $requestHeadersToLower,
            CASE_LOWER
        );

        if (array_key_exists("x-wing-token", $requestHeaders) == false) {
            header("HTTP/1.1 401 Unauthorized");
            echo "Missing x-wing-token header";
            exit();
        } elseif ($requestHeaders["x-wing-token"] != $psSecurityToken) {
            header(Tools::strtolower("HTTP/1.1 401 Unauthorized"));
            echo "Wrong credentials";
            exit();
        } else {
            $sku = Tools::getValue("sku");

            if (!$sku) {
                header("HTTP/1.1 403 Forbidden");
                echo "Missing sku";
                exit();
            }

            $productsFromPrestashop = $this->module->products->getProducts(
                $shopId,
                1,
                1,
                $sku,
                null
            );

            $total = $productsFromPrestashop["total"];
            $data = $productsFromPrestashop["data"];

            if ($total != 1) {
                header("HTTP/1.1 403 Forbidden");
                if (!$total) {
                    echo "There are no products with SKU \"$sku\"";
                } else {
                    echo "Sku must be unique. there are \"$total\" products with SKU \"$sku\"";
                }
                exit();
            }

            $quantity = (int) Tools::getValue("quantity");

            $id_product = $data[0]["id_product"];
            $id_product_attribute = $data[0]["id_product_attribute"];

            $product = $this->module->products->updateProduct(
                $shopId,
                $sku,
                $id_product,
                $id_product_attribute,
                $quantity
            );

            header("Content-Type:application/json;charset=utf-8");
            echo json_encode($product);
            exit();
        }
    }
}
