<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once _PS_MODULE_DIR_ .
    DIRECTORY_SEPARATOR .
    'wing' .
    DIRECTORY_SEPARATOR .
    'classes' .
    DIRECTORY_SEPARATOR .
    'helpers.php';

/**
 *
 * @method public void run()
 */

class WingUpdateOrderInfoModuleFrontController extends ModuleFrontController
{
    private $shopId = null;

    public function initContent()
    {
        $this->checkCredentials();

        $pOrderRef = Tools::getValue('ref');
        $parameterOrderRef = !empty($pOrderRef) ? $pOrderRef : null;

        $pTrackingId = Tools::getValue('tracking');
        $parameterTrackingId = !empty($pTrackingId) ? $pTrackingId : null;

        if (!$parameterOrderRef) {
            $this->displayError("400", array(
                "status" => "bad_request",
                "message" => "missing_ref"
            ));
        }

        if (!$parameterTrackingId) {
            $this->displayError("400", array(
                "status" => "bad_request",
                "message" => "missing_tracking"
            ));
        }

        $order = new Order($parameterOrderRef);
        if (!Validate::isLoadedObject($order)) {
            WingHelpers::log('404 - Order not found: ' . $parameterOrderRef);
            $this->displayError("404", array(
                "status" => "order_not_found",
                "message" => "order " . $parameterOrderRef
            ));
        }

        $wingShippedStatus = (int) Configuration::get(
            'WING_SHOP_' . $this->shopId . '_SHIPPED_STATUS'
        );
        if (!$wingShippedStatus) {
            $wingShippedStatus = 4;
        }
        WingHelpers::log('wingShippedStatus:' . $wingShippedStatus);

        $previousFulfillment = $order->getHistory(
            $order->id_lang,
            $wingShippedStatus,
            false
        );

        if ($previousFulfillment) {
            $prev = (object) $previousFulfillment[0];
            $response = array(
                "status" => "alreadyFulfilled",
                "fulfilledDate" => $prev->date_add,
                "id_order_state" => $prev->id_order_state,
                "state_name" => $prev->ostate_name
            );
            $this->displayResponse($response);
        } else {
            $order->shipping_number = $parameterTrackingId;
            $order->update();

            $order_carrier = new OrderCarrier($order->getIdOrderCarrier());
            $order_carrier->tracking_number = $parameterTrackingId;
            $order_carrier->update();

            $carrier = new Carrier($order->id_carrier);
            $urlTracking = str_replace(
                '@',
                $parameterTrackingId,
                $carrier->url
            );
            $templateVars = array('{followup}' => $urlTracking);

            $order_carrier = new OrderCarrier(
                (int) $order->getIdOrderCarrier()
            );
            $history = new OrderHistory();
            $history->id_order = (int) $order->id;
            $history->date_add = date('Y-m-d H:i:s');
            $history->changeIdOrderState($wingShippedStatus, $order, true);
            $history->addWithemail(true, $templateVars);
            $this->displayResponse(array("status" => "success"));
        }
    }

    private function checkCredentials()
    {
        $context = Context::getContext();
        $this->shopId = (int) $context->shop->id;
        $apiKey = Configuration::get('WING_SHOP_' . $this->shopId . '_API_KEY');
        $apiSecret = Configuration::get(
            'WING_SHOP_' . $this->shopId . '_API_SECRET'
        );
        $psSecurityToken = sha1($apiKey . ':' . $apiSecret);

        /* In case of previous Apache version or nginx server use */
        $requestHeadersToLower = !function_exists('getallheaders')
            ? WingHelpers::getallheaders()
            : getallheaders();

        $requestHeaders = array_change_key_case(
            $requestHeadersToLower,
            CASE_LOWER
        );
        if (array_key_exists('x-wing-token', $requestHeaders) == false) {
            $this->displayError("401", array(
                "status" => "unauthorized",
                "message" => "missing_token"
            ));
        } elseif ($requestHeaders['x-wing-token'] != $psSecurityToken) {
            $this->displayError("401", array(
                "status" => "unauthorized",
                "message" => "invalid_token"
            ));
        }
    }

    private function displayError($status, $error)
    {
        header('HTTP/1.1 ' . $status . ' Unauthorized');
        header('Content-Type:application/json;charset=utf-8', false);
        $json = Tools::jsonEncode($error);
        echo $json;
        exit();
    }

    private function displayResponse($response)
    {
        header('Content-Type:application/json;charset=utf-8');
        $json = Tools::jsonEncode($response);
        echo $json;
        exit();
    }
}
