<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit();
}

/**
 *
 * @method public   void        __construct()
 *
 * @method public   boolean install(array $context, string $name)
 * @method public   boolean uninstall(string $name)
 */

class WingOperationsTabs
{
    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * @method public install
     *
     * @param array $context
     * @param string $name
     *
     * @return Context
     */
    public function install($context, $name)
    {
        $idTab = Tab::getIdFromClassName('AdminWing');
        if (!$idTab) {
            $tab = new Tab();
            $tab->name[$context->language->id] = "Wing";
            $tab->class_name = 'AdminWing';
            $tab->module = 'Wing';
            $tab->active = 1;

            if (version_compare(_PS_VERSION_, '1.6.0.1', '>=')) {
                $tab->id_parent = (int) Tab::getIdFromClassName('IMPROVE');
            } else {
                $tab->id_parent = 13; // transport
            }

            $languages = Language::getLanguages(false);

            foreach ($languages as $lang) {
                $tab->name[$lang['id_lang']] = $name;
            }

            return $tab->add();
        }

        return true;
    }

    /**
     * @method public uninstall
     *
     * @param string $name
     *
     * @return Context
     */
    public function uninstall($name)
    {
        $idTab = Tab::getIdFromClassName($name);

        if ($idTab) {
            $tab = new Tab($idTab);

            return $tab->delete();
        } else {
            return false;
        }
    }
}
