<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined("_PS_VERSION_")) {
    exit();
}

/**
 *
 * @method public   void        __construct()
 * @method public   array       getCarriers(int $shopId, int $page, int $size)
 */

class WingOperationsCarriers
{
    protected $context;

    /* Class methods */
    /**
     * @method __construct
     *
     * Constructor
     *
     * @return void
     */
    public function __construct()
    {
        $this->setContext();
    }

    /**
     * @method public uninstall
     *
     * @return Context
     */
    private function setContext()
    {
        $this->context = Context::getContext();
    }

    /**
     * @method public getCarriers
     *
     * @return array
     */
    public function getCarriers($shopId, $page, $size)
    {
        $ps_carrier_lang = _DB_PREFIX_ . "carrier_lang";
        $ps_carrier = _DB_PREFIX_ . "carrier";

        $offset = ($page - 1) * $size;
        $db = Db::getInstance();
        $carriers = $db->executeS(
            "SELECT * from $ps_carrier_lang cl
          LEFT JOIN $ps_carrier c ON c.id_carrier = cl.id_carrier
          WHERE id_shop = $shopId
          AND deleted != 1
          AND active = 1
          LIMIT $offset, $size"
        );
        if ($carriers === false) {
            return ["error" => $db->getMsgError()];
        }

        return [
            "shopId" => $shopId,
            "page" => $page,
            "size" => $size,
            "data" => $carriers
        ];
    }
}
